THEMES = {
    "Dark": """
        /* A modern, Apple-inspired dark theme. */
        QMainWindow, QDialog, QWidget {
            font-size: 11pt;
            background-color: #1e1e1e;
            color: #e0e0e0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Helvetica Neue', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: #2c2c2e;
            border: 1px solid #3a3a3c;
            border-radius: 8px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #e0e0e0;
        }
        QPushButton {
            background-color: #3a3a3c;
            color: #e0e0e0;
            border: 1px solid #4a4a4c;
            padding: 8px 14px;
            border-radius: 8px;
            font-weight: 600;
        }
        QPushButton:hover {
            background-color: #4a4a4c;
            border-color: #5a5a5c;
        }
        QPushButton:pressed { background-color: #2c2c2e; }
        QPushButton:checked {
            color: #ffffff;
            font-weight: bold;
            border: 1px solid #0a84ff;
            background-color: #0a84ff;
        }
        QListWidget, QLineEdit {
            background-color: #2c2c2e;
            border: 1px solid #3a3a3c;
            border-radius: 8px;
            padding: 6px;
            color: #e0e0e0;
        }
        QListWidget::item:selected {
            color: #ffffff;
            background-color: #0a84ff;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #2c2c2e;
            border: 1px solid #3a3a3c;
            border-radius: 8px;
            padding: 6px;
            color: #e0e0e0;
        }
        QComboBox QAbstractItemView {
            background-color: #3a3a3c;
            border: 1px solid #4a4a4c;
            selection-background-color: #0a84ff;
            color: #e0e0e0;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #e0e0e0; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #2c2c2e;
            border: 1px solid #4a4a4c;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #5a5a5c; }
        QCheckBox::indicator:checked {
            background-color: #0a84ff;
            border-color: #0a84ff;
        }
        QFrame#stemPad {
            background-color: #2c2c2e;
            border: 1px solid #3a3a3c;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #3a3a3c; height: 4px; background: #2c2c2e; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #e0e0e0; border: 2px solid #0a84ff; width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #3a3a3c;
            border-radius: 6px;
            text-align: center;
            color: #e0e0e0;
            background-color: #2c2c2e;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #0a84ff;
        }
    """,
    "Light": """
        /* A clean, modern, Apple-inspired light theme. */
        QMainWindow, QDialog, QWidget {
            font-size: 11pt;
            background-color: #f5f5f7;
            color: #1d1d1f;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Helvetica Neue', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: #ffffff;
            border: 1px solid #dcdcdc;
            border-radius: 8px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #333333;
        }
        QPushButton {
            background-color: #ffffff;
            color: #1d1d1f;
            border: 1px solid #c6c6c6;
            padding: 8px 14px;
            border-radius: 8px;
            font-weight: 600;
        }
        QPushButton:hover {
            background-color: #f0f0f0;
            border-color: #b0b0b0;
        }
        QPushButton:pressed { background-color: #e0e0e0; }
        QPushButton:checked {
            color: #ffffff;
            font-weight: bold;
            border: 1px solid #007aff;
            background-color: #007aff;
        }
        QListWidget, QLineEdit {
            background-color: #ffffff;
            border: 1px solid #c6c6c6;
            border-radius: 8px;
            padding: 6px;
            color: #1d1d1f;
        }
        QListWidget::item:selected {
            color: #ffffff;
            background-color: #007aff;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #ffffff;
            border: 1px solid #c6c6c6;
            border-radius: 8px;
            padding: 6px;
            color: #1d1d1f;
        }
        QComboBox QAbstractItemView {
            background-color: #ffffff;
            border: 1px solid #c6c6c6;
            selection-background-color: #007aff;
            color: #1d1d1f;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #1d1d1f; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #ffffff;
            border: 1px solid #c6c6c6;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #b0b0b0; }
        QCheckBox::indicator:checked {
            background-color: #007aff;
            border-color: #007aff;
        }
        QFrame#stemPad {
            background-color: #ffffff;
            border: 1px solid #dcdcdc;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #dcdcdc; height: 4px; background: #e5e5e7; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #ffffff; border: 2px solid #007aff; width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #dcdcdc;
            border-radius: 6px;
            text-align: center;
            color: #1d1d1f;
            background-color: #ffffff;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #007aff;
        }
    """,
    "Synthwave '84": """
        /* A retro-tech, neon-drenched theme. */
        QMainWindow, QDialog, QWidget {
            font-size: 11pt;
            background-color: #2a2139;
            color: #f0f0f0;
            font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
        }
        QGroupBox {
            background-color: rgba(0, 0, 0, 0.2);
            border: 1px solid #ff00ff;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #00ffff;
        }
        QPushButton {
            background-color: #4a3a60;
            color: #00ffff;
            border: 1px solid #ff00ff;
            padding: 8px 14px;
            border-radius: 6px;
            font-weight: 700;
        }
        QPushButton:hover {
            background-color: #5f4a7d;
            color: #ffffff;
            border-color: #00ffff;
        }
        QPushButton:pressed { background-color: #1d1726; }
        QPushButton:checked {
            color: #000000;
            font-weight: bold;
            border: 1px solid #00ffff;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop:0 #ff00ff, stop:1 #00ffff);
        }
        QListWidget, QLineEdit {
            background-color: #1d1726;
            border: 1px solid #ff00ff;
            border-radius: 6px;
            padding: 6px;
            color: #f0f0f0;
        }
        QListWidget::item:selected {
            color: #000000;
            background-color: #ff00ff;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #1d1726;
            border: 1px solid #ff00ff;
            border-radius: 6px;
            padding: 6px;
            color: #f0f0f0;
        }
        QComboBox QAbstractItemView {
            background-color: #1d1726;
            border: 1px solid #ff00ff;
            selection-background-color: #ff00ff;
            color: #f0f0f0;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #f0f0f0; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #1d1726;
            border: 1px solid #ff00ff;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #00ffff; }
        QCheckBox::indicator:checked {
            background-color: #00ffff;
            border-color: #00ffff;
        }
        QFrame#stemPad {
            background-color: rgba(0, 0, 0, 0.2);
            border: 1px solid #ff00ff;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #ff00ff; height: 4px; background: #1d1726; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #00ffff; border: 2px solid #ff00ff; width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #ff00ff;
            border-radius: 6px;
            text-align: center;
            color: #f0f0f0;
            background-color: #1d1726;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0,
                stop:0 #ff00ff, stop:1 #00ffff);
        }
    """,
    "Graphite & Amber": """
        /* A high-contrast dark theme with fiery orange/amber accents. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #222222;
            color: #f5f5f5;
            font-family: 'Segoe UI', 'Helvetica', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: #2d2d2d;
            border: 1px solid #444444;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #ffb700;
        }
        QPushButton {
            background-color: #3a3a3a;
            color: #f5f5f5;
            border: 1px solid #555555;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: 700;
        }
        QPushButton:hover {
            border-color: #ffb700;
            background-color: #4a4a4a;
        }
        QPushButton:pressed { background-color: #2d2d2d; }
        QPushButton:checked {
            color: #000000;
            font-weight: bold;
            border: 1px solid #ffb700;
            background-color: #ffb700;
        }
        QListWidget, QLineEdit {
            background-color: #1a1a1a;
            border: 1px solid #444444;
            border-radius: 6px;
            padding: 5px;
            color: #f5f5f5;
        }
        QListWidget::item:selected {
            color: #000000;
            background-color: #ffb700;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #1a1a1a;
            border: 1px solid #444444;
            border-radius: 6px;
            padding: 5px;
            color: #f5f5f5;
        }
        QComboBox QAbstractItemView {
            background-color: #2d2d2d;
            border: 1px solid #555555;
            selection-background-color: #ffb700;
            color: #f5f5f5;
            selection-color: #000000;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #f5f5f5; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #1a1a1a;
            border: 1px solid #444444;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #ffb700; }
        QCheckBox::indicator:checked {
            background-color: #ffb700;
            border-color: #ffb700;
        }
        QFrame#stemPad {
            background-color: #2d2d2d;
            border: 1px solid #444444;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #444444; height: 4px; background: #2d2d2d; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #f5f5f5; border: 2px solid #ffb700; width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #444444;
            border-radius: 6px;
            text-align: center;
            color: #f5f5f5;
            background-color: #2d2d2d;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #ffb700;
        }
    """,
    "Retro Groove": """
        /* A fun, warm theme inspired by 70s aesthetics. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #3d2c22;
            color: #f3e5d0;
            font-family: 'Verdana', 'Geneva', sans-serif;
        }
        QGroupBox {
            background-color: #4a372c;
            border: 1px solid #694d3c;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #f3e5d0;
        }
        QPushButton {
            background-color: #7a5c49;
            color: #f3e5d0;
            border: 1px solid #9c7861;
            padding: 8px 12px;
            border-radius: 4px;
            font-weight: 700;
        }
        QPushButton:hover {
            border-color: #f4a261;
            background-color: #8b6b57;
        }
        QPushButton:pressed { background-color: #694d3c; }
        QPushButton:checked {
            color: #3d2c22;
            font-weight: bold;
            border: 1px solid #e76f51;
            background-color: #f4a261;
        }
        QListWidget, QLineEdit {
            background-color: #2b1d16;
            border: 1px solid #694d3c;
            border-radius: 4px;
            padding: 5px;
            color: #f3e5d0;
        }
        QListWidget::item:selected {
            color: #2b1d16;
            background-color: #e76f51;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #2b1d16;
            border: 1px solid #694d3c;
            border-radius: 4px;
            padding: 5px;
            color: #f3e5d0;
        }
        QComboBox QAbstractItemView {
            background-color: #4a372c;
            border: 1px solid #694d3c;
            selection-background-color: #e76f51;
            color: #f3e5d0;
            selection-color: #2b1d16;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #f3e5d0; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #2b1d16;
            border: 1px solid #694d3c;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #f4a261; }
        QCheckBox::indicator:checked {
            background-color: #f4a261;
            border-color: #e76f51;
        }
        QFrame#stemPad {
            background-color: #4a372c;
            border: 1px solid #694d3c;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #694d3c; height: 6px; background: #2b1d16; border-radius: 3px;
        }
        QSlider::handle:horizontal {
            background: #f3e5d0; border: 2px solid #2b1d16; width: 18px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #694d3c;
            border-radius: 6px;
            text-align: center;
            color: #f3e5d0;
            background-color: #2b1d16;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #f4a261;
        }
    """,
    "Olive Grove": """
        /* An earthy, grounded theme with olive greens and cream text. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #283618;
            color: #fefae0;
            font-family: 'Segoe UI', 'Helvetica', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: #3a4a22;
            border: 1px solid #606c38;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #fefae0;
        }
        QPushButton {
            background-color: #606c38;
            color: #fefae0;
            border: 1px solid #78854b;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: 700;
        }
        QPushButton:hover {
            border-color: #dda15e;
            background-color: #738044;
        }
        QPushButton:pressed { background-color: #515a30; }
        QPushButton:checked {
            color: #283618;
            font-weight: bold;
            border: 1px solid #bc6c25;
            background-color: #dda15e;
        }
        QListWidget, QLineEdit {
            background-color: #1c2510;
            border: 1px solid #606c38;
            border-radius: 6px;
            padding: 5px;
            color: #fefae0;
        }
        QListWidget::item:selected {
            color: #283618;
            background-color: #dda15e;
            border-radius: 4px;
        }
        QComboBox {
            background-color: #1c2510;
            border: 1px solid #606c38;
            border-radius: 6px;
            padding: 5px;
            color: #fefae0;
        }
        QComboBox QAbstractItemView {
            background-color: #3a4a22;
            border: 1px solid #78854b;
            selection-background-color: #dda15e;
            color: #fefae0;
            selection-color: #283618;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #fefae0; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #1c2510;
            border: 1px solid #606c38;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #dda15e; }
        QCheckBox::indicator:checked {
            background-color: #dda15e;
            border-color: #bc6c25;
        }
        QFrame#stemPad {
            background-color: #3a4a22;
            border: 1px solid #606c38;
            border-radius: 6px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #606c38; height: 4px; background: #1c2510; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #fefae0; border: 2px solid #1c2510; width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #606c38;
            border-radius: 6px;
            text-align: center;
            color: #fefae0;
            background-color: #1c2510;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #dda15e;
        }
    """,
    "DiceTrax Engraved": """
        /* Inspired by a woodcut/linocut print aesthetic, like the DiceTrax logo. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #e6e0d4; /* Aged paper background */
            color: #333333; /* Dark, "engraved" text */
            font-family: 'Georgia', serif; /* Classic, slightly textured font */
        }
        QGroupBox {
            background-color: #d1cbc0; /* Slightly darker paper for distinction */
            border: 1px solid #555555; /* Dark, defined border */
            border-radius: 4px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #333333;
        }
        QPushButton {
            background-color: #8c8378; /* Muted stone/wood-like button */
            color: #ffffff;
            border: 1px solid #555555;
            padding: 8px 12px;
            border-radius: 4px;
            font-weight: 700;
        }
        QPushButton:hover {
            background-color: #a39b90; /* Lighter on hover */
            border-color: #333333;
        }
        QPushButton:pressed { background-color: #726a61; }
        QPushButton:checked {
            color: #ffffff;
            font-weight: bold;
            border: 1px solid #4a4a4a;
            background-color: #333333; /* Dark "engraved" look for active */
        }
        QListWidget, QLineEdit {
            background-color: #c9c3b8; /* Slightly textured light background */
            border: 1px solid #555555;
            border-radius: 4px;
            padding: 5px;
            color: #333333;
        }
        QListWidget::item:selected {
            color: #ffffff;
            background-color: #4a4a4a; /* Dark selection, like etched in */
            border-radius: 2px;
        }
        QComboBox {
            background-color: #c9c3b8;
            border: 1px solid #555555;
            border-radius: 4px;
            padding: 5px;
            color: #333333;
        }
        QComboBox QAbstractItemView {
            background-color: #d1cbc0;
            border: 1px solid #555555;
            selection-background-color: #4a4a4a;
            color: #333333;
            selection-color: #ffffff;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #333333; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #c9c3b8;
            border: 1px solid #555555;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #333333; }
        QCheckBox::indicator:checked {
            background-color: #333333;
            border-color: #333333;
        }
        QFrame#stemPad {
            background-color: #d1cbc0;
            border: 1px solid #555555;
            border-radius: 4px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #555555; height: 4px; background: #c9c3b8; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #333333; /* Dark handle */
            border: 2px solid #555555;
            width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #555555;
            border-radius: 6px;
            text-align: center;
            color: #333333;
            background-color: #c9c3b8;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background-color: #333333;
        }
    """,
    "Cyberpunk Neon": """
        /* A dark, futuristic theme with glowing blue and purple accents. */
        QMainWindow, QDialog, QWidget {
            font-size: 11pt;
            background-color: #0d001a; /* Very dark, deep purple */
            color: #b3ecff; /* Bright light blue/cyan for text */
            font-family: 'Orbitron', 'Roboto Mono', monospace; /* Techy font */
        }
        QGroupBox {
            background-color: rgba(10, 0, 20, 0.4); /* Slightly transparent dark purple */
            border: 1px solid #4d0099; /* Deep purple border */
            border-radius: 8px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #8a2be2; /* Blue-violet for titles */
        }
        QPushButton {
            background-color: #1a0033; /* Dark button base */
            color: #b3ecff;
            border: 1px solid #00c4ff; /* Neon blue border */
            padding: 8px 14px;
            border-radius: 6px;
            font-weight: 700;
        }
        QPushButton:hover {
            background-color: #2a004d;
            border-color: #00eaff; /* Brighter neon blue */
            color: #ffffff;
        }
        QPushButton:pressed { background-color: #05000a; }
        QPushButton:checked {
            color: #000000;
            font-weight: bold;
            border: 1px solid #8a2be2;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop:0 #8a2be2, stop:1 #00c4ff); /* Gradient active */
        }
        QListWidget, QLineEdit {
            background-color: #05000a; /* Very dark input fields */
            border: 1px solid #4d0099;
            border-radius: 6px;
            padding: 6px;
            color: #b3ecff;
        }
        QListWidget::item:selected {
            color: #ffffff;
            background-color: #00c4ff; /* Neon blue selection */
            border-radius: 4px;
        }
        QComboBox {
            background-color: #05000a;
            border: 1px solid #4d0099;
            border-radius: 6px;
            padding: 6px;
            color: #b3ecff;
        }
        QComboBox QAbstractItemView {
            background-color: #1a0033;
            border: 1px solid #4d0099;
            selection-background-color: #00c4ff;
            color: #b3ecff;
            selection-color: #000000;
            outline: 0px;
        }
        QCheckBox { spacing: 8px; color: #b3ecff; }
        QCheckBox::indicator {
            width: 16px; height: 16px;
            background-color: #05000a;
            border: 1px solid #4d0099;
            border-radius: 4px;
        }
        QCheckBox::indicator:hover { border-color: #00c4ff; }
        QCheckBox::indicator:checked {
            background-color: #00c4ff;
            border-color: #00c4ff;
        }
        QFrame#stemPad {
            background-color: rgba(10, 0, 20, 0.4);
            border: 1px solid #4d0099;
            border-radius: 8px;
        }
        QSlider::groove:horizontal {
            border: 1px solid #4d0099; height: 4px; background: #05000a; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #b3ecff; /* Light blue handle */
            border: 2px solid #8a2be2; /* Blue-violet border */
            width: 16px; margin: -8px 0; border-radius: 9px;
        }
        QProgressBar {
            border: 1px solid #4d0099;
            border-radius: 6px;
            text-align: center;
            color: #b3ecff;
            background-color: #05000a;
        }
        QProgressBar::chunk {
            border-radius: 5px;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0,
                stop:0 #8a2be2, stop:1 #00c4ff);
        }
    """
}