# styles.py

THEMES = {
    "Dark Knight": """
        /* A deep, modern dark theme with vibrant gradient accents. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #0d1117;
            color: #e8eef7;
            font-family: 'Segoe UI', 'Helvetica', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: rgba(13, 17, 23, 0.86);
            border: 1px solid #273042;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #d7e3f7;
        }
        QPushButton {
            background-color: #121722;
            color: #e8eef7;
            border: 1px solid #2b3850;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: 700;
        }
        QPushButton:hover {
            border-color: #4aa3ff;
            background-color: #1c263a;
        }
        QPushButton:pressed { background-color: #0f1520; }
        QPushButton:checked, QPushButton#analyzeButton {
            color: #ffffff;
            font-weight: bold;
            border: 1px solid #56c9ff;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop:0 #ff4dd2, stop:0.5 #ff9a35, stop:1 #21e6ff);
        }
        QListWidget, QLineEdit, QComboBox {
            background-color: #0f1520;
            border: 1px solid #273042;
            border-radius: 6px;
            padding: 5px;
        }
        QListWidget::item:selected {
            color: #0b0f16;
            border: 1px solid #56c9ff;
            background: qlineargradient(x1:0, y1:0, x2:1, y2:0, stop:0 #ff4dd2, stop:0.5 #ff9a35, stop:1 #21e6ff);
        }
        QSlider::groove:horizontal {
            border: 1px solid #273042; height: 4px; background: #141c2a; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #0b0f16; border: 2px solid #7ce8ff; width: 16px; margin: -8px 0; border-radius: 9px;
        }
    """,
    "Arctic Light": """
        /* A clean, professional light theme with blue accents. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #f0f2f5;
            color: #1c1e21;
            font-family: 'Segoe UI', 'Helvetica', 'Arial', sans-serif;
        }
        QGroupBox {
            background-color: #ffffff;
            border: 1px solid #d0d7de;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #333;
        }
        QPushButton {
            background-color: #f6f8fa;
            color: #1c1e21;
            border: 1px solid #d0d7de;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: 600;
        }
        QPushButton:hover {
            border-color: #0078d4;
            background-color: #eef5fc;
        }
        QPushButton:pressed { background-color: #dbeaf7; }
        QPushButton:checked, QPushButton#analyzeButton {
            color: #ffffff;
            font-weight: bold;
            border: 1px solid #005a9e;
            background-color: #0078d4;
        }
        QListWidget, QLineEdit, QComboBox {
            background-color: #ffffff;
            border: 1px solid #d0d7de;
            border-radius: 6px;
            padding: 5px;
        }
        QListWidget::item:selected {
            color: #ffffff;
            background-color: #0078d4;
        }
        QSlider::groove:horizontal {
            border: 1px solid #d0d7de; height: 4px; background: #e5e7ea; border-radius: 2px;
        }
        QSlider::handle:horizontal {
            background: #ffffff; border: 2px solid #0078d4; width: 16px; margin: -8px 0; border-radius: 9px;
        }
    """,
    "Retro Groove": """
        /* A fun, warm theme inspired by 70s aesthetics. */
        QMainWindow, QDialog, QWidget {
            font-size: 10.5pt;
            background-color: #3d2c22;
            color: #f3e5d0;
            font-family: 'Verdana', 'Geneva', sans-serif;
        }
        QGroupBox {
            background-color: #4a372c;
            border: 1px solid #694d3c;
            border-radius: 6px;
            margin-top: 10px;
            font-weight: 600;
        }
        QGroupBox::title {
            subcontrol-origin: margin; subcontrol-position: top center;
            padding: 0 8px; color: #f3e5d0;
        }
        QPushButton {
            background-color: #7a5c49;
            color: #f3e5d0;
            border: 1px solid #9c7861;
            padding: 8px 12px;
            border-radius: 4px;
            font-weight: 700;
        }
        QPushButton:hover {
            border-color: #f4a261;
            background-color: #8b6b57;
        }
        QPushButton:pressed { background-color: #694d3c; }
        QPushButton:checked, QPushButton#analyzeButton {
            color: #3d2c22;
            font-weight: bold;
            border: 1px solid #e76f51;
            background-color: #f4a261;
        }
        QListWidget, QLineEdit, QComboBox {
            background-color: #2b1d16;
            border: 1px solid #694d3c;
            border-radius: 4px;
            padding: 5px;
        }
        QListWidget::item:selected {
            color: #2b1d16;
            background-color: #e76f51;
        }
        QSlider::groove:horizontal {
            border: 1px solid #694d3c; height: 6px; background: #2b1d16; border-radius: 3px;
        }
        QSlider::handle:horizontal {
            background: #f3e5d0; border: 2px solid #2b1d16; width: 18px; margin: -8px 0; border-radius: 9px;
        }
    """
}